---

Difficulty: Medium  
Source: Daily-Question (POTD 27-Nov)  
Tags: 
  - Arrays
  - Breadth-First Search
  - Graph     
---

# 🚀 *3243 - Shortest Distance After Road Addition Queries I* 🧠

### Problem Link:  
[**LeetCode - Shortest Distance After Road Addition Queries I**](https://leetcode.com/problems/shortest-distance-after-road-addition-queries-i/description/?envType=daily-question&envId=2024-11-27)

## 💡 **Problem Breakdown:**

You are given an integer `n` representing the number of cities and a 2D integer array `queries`. The cities are numbered from `0` to `n-1`. Initially, there is a unidirectional road from city `i` to city `i+1` for all `0 <= i < n-1`.

Each query `queries[i] = [ui, vi]` represents the addition of a new unidirectional road from city `ui` to city `vi`. After each query, you need to find the length of the shortest path from city `0` to city `n-1`.

Return an array `answer` where for each `i` in the range `[0, queries.length - 1]`, `answer[i]` is the length of the shortest path from city `0` to city `n-1` after processing the first `i + 1` queries.

## 🔍 **Example Walkthrough:**

### Example 1:

**Input:**  
`n = 5`, `queries = [[2, 4], [0, 2], [0, 4]]`

**Output:**  
`[3, 2, 1]`  


**Explanation:**  

<img src="https://github.com/user-attachments/assets/41f132f3-26b5-41ff-b524-16449afca396" width="38%">

After the addition of the road from 2 to 4, the length of the shortest path from 0 to 4 is 3.


<img src="https://github.com/user-attachments/assets/726372fe-6074-4ffc-932a-e06482a2fa31" width="38%">

After the addition of the road from 0 to 2, the length of the shortest path from 0 to 4 is 2.


<img src="https://github.com/user-attachments/assets/65f78a68-286e-4569-a2c0-643c904c5b0c" width="38%">

After the addition of the road from 0 to 4, the length of the shortest path from 0 to 4 is 1.

### Example 2:

**Input:**  
`n = 4`, `queries = [[0, 3], [0, 2]]`

**Output:**  
`[1, 1]`  


<img src="https://github.com/user-attachments/assets/554680a3-e887-4649-954c-eca1391c328b" width="38%">

After the addition of the road from 0 to 3, the length of the shortest path from 0 to 3 is 1.


<img src="https://github.com/user-attachments/assets/99eac8e1-41db-4325-88bf-f72a497df314" width="38%">

After the addition of the road from 0 to 2, the length of the shortest path remains 1.

Constraints:

- `3 <= n <= 500`
- `1 <= queries.length <= 500`
- `queries[i].length == 2`
- `0 <= queries[i][0] < queries[i][1] < n`
- `1 < queries[i][1] - queries[i][0]`
- There are no repeated roads among the queries.


## 🎯 **My Approach:**

1. **Graph Representation:**
   - Use an adjacency list to represent the cities and the roads between them.
   - Initially, each city `i` has a road to city `i+1`.

2. **BFS for Shortest Path Calculation:**
   - Perform a Breadth-First Search (BFS) to find the shortest path from city 0 to city `n-1` after each road addition.

3. **Handling Queries:**
   - After processing each query, update the graph with the new road and compute the shortest path from city 0 to city `n-1` using BFS.



## 🕒 **Time Complexity:**
- **O(n × q):**  
  - Each BFS runs in O(n), and we perform BFS for each of the `q` queries.
- **Space Complexity:**  
  - **O(n):** For storing the graph and distances.

### <div align="center">_*or*_</div>

- **O(n + m):**
  - n is the number of cities and m is the number of queries. Each BFS runs in O(n + m) time.
- **Space Complexity:**
  - **O(n + m):** Space is used to store the graph and the distance array.

## 📝 **Solution Code**

## Code (C)

```c
int* shortestDistanceAfterQueries(int n, int** queries, int queriesSize, int* queriesColSize, int* returnSize) {
    *returnSize = queriesSize;
    int* result = (int*)malloc(queriesSize * sizeof(int));
    int** graph = (int**)malloc(n * sizeof(int*));
    int* sizes = (int*)calloc(n, sizeof(int));
    
    for (int i = 0; i < n; ++i) {
        graph[i] = (int*)malloc(n * sizeof(int));
        if (i < n - 1) graph[i][sizes[i]++] = i + 1;
    }
    
    int* dist = (int*)malloc(n * sizeof(int));
    
    void bfs() {
        memset(dist, -1, n * sizeof(int));
        dist[0] = 0;
        int* queue = (int*)malloc(n * sizeof(int));
        int front = 0, back = 0;
        queue[back++] = 0;
        
        while (front < back) {
            int u = queue[front++];
            for (int i = 0; i < sizes[u]; ++i) {
                int v = graph[u][i];
                if (dist[v] == -1) {
                    dist[v] = dist[u] + 1;
                    queue[back++] = v;
                }
            }
        }
        free(queue);
    }
    
    bfs();
    
    for (int i = 0; i < queriesSize; ++i) {
        int u = queries[i][0], v = queries[i][1];
        graph[u][sizes[u]++] = v;
        if (dist[v] == -1 || dist[v] > dist[u] + 1) {
            bfs();
        }
        result[i] = dist[n - 1];
    }
    
    for (int i = 0; i < n; ++i) free(graph[i]);
    free(graph);
    free(sizes);
    free(dist);
    return result;
}
```

## Code (C++)

```cpp
class Solution {
public:
    vector<int> shortestDistanceAfterQueries(int n, vector<vector<int>>& queries) {
        vector<vector<int>> graph(n);
        for (int i = 0; i < n - 1; ++i)
            graph[i].push_back(i + 1);
        
        vector<int> dist(n, -1);
        auto bfs = [&]() {
            fill(dist.begin(), dist.end(), -1);
            dist[0] = 0;
            queue<int> q;
            q.push(0);
            
            while (!q.empty()) {
                int u = q.front();
                q.pop();
                for (int v : graph[u]) {
                    if (dist[v] == -1) {
                        dist[v] = dist[u] + 1;
                        q.push(v);
                    }
                }
            }
        };
        
        bfs(); 
        vector<int> result;
        
        for (auto& query : queries) {
            graph[query[0]].push_back(query[1]);
            if (dist[query[1]] == -1 || dist[query[1]] > dist[query[0]] + 1) {
                bfs(); 
            }
            result.push_back(dist[n - 1]);
        }
        
        return result;
    }
};
```

## Code (Java)

```java
import java.util.*;
class Solution {
    public int[] shortestDistanceAfterQueries(int n, int[][] queries) {
        List<Set<Integer>> graph = new ArrayList<>();
        for (int i = 0; i < n; i++) {
            graph.add(new HashSet<>());
        }
        for (int i = 0; i < n - 1; i++) {
            graph.get(i).add(i + 1); 
        }
        int[] result = new int[queries.length];
        int[] dist = new int[n]; 
        for (int i = 0; i < queries.length; i++) {
            int u = queries[i][0], v = queries[i][1];
            if (!graph.get(u).contains(v)) {
                graph.get(u).add(v); 
            }
            Arrays.fill(dist, -1); 
            result[i] = bfs(graph, dist, n);
        }
        return result;
    }
    private int bfs(List<Set<Integer>> graph, int[] dist, int n) {
        dist[0] = 0;
        Queue<Integer> queue = new LinkedList<>();
        queue.offer(0);
        while (!queue.isEmpty()) {
            int u = queue.poll();
            for (int v : graph.get(u)) {
                if (dist[v] == -1) {
                    dist[v] = dist[u] + 1;
                    if (v == n - 1) {
                        return dist[v];
                    }
                    queue.offer(v);
                }
            }
        }
        return -1; 
    }
}
```

## Code (Python)

```python3
from collections import deque
from typing import List
class Solution:
    def shortestDistanceAfterQueries(self, n: int, queries: List[List[int]]) -> List[int]:
        g = {i: [i + 1] for i in range(n - 1)}
        ans = []
        def bfs() -> int:
            q = deque([0])
            dist = [-1] * n
            dist[0] = 0  
            while q:
                u = q.popleft()
                for v in g[u]:
                    if dist[v] == -1:  
                        dist[v] = dist[u] + 1
                        if v == n - 1:  
                            return dist[v]
                        q.append(v)
            return -1  
        for u, v in queries:
            g[u].append(v)  
            ans.append(bfs())  
        return ans
```

## Code (Rust)

```rust
use std::collections::{HashSet, VecDeque};
impl Solution {
    pub fn shortest_distance_after_queries(n: i32, queries: Vec<Vec<i32>>) -> Vec<i32> {
        let n = n as usize;
        let mut graph: Vec<HashSet<usize>> = vec![HashSet::new(); n];
        for i in 0..n - 1 {
            graph[i].insert(i + 1);
        }
        let bfs = |graph: &Vec<HashSet<usize>>, n: usize| -> i32 {
            let mut dist = vec![-1; n];  
            let mut queue = VecDeque::new();
            dist[0] = 0; 
            queue.push_back(0);
            while let Some(u) = queue.pop_front() {
                for &v in &graph[u] {
                    if dist[v] == -1 {  
                        dist[v] = dist[u] + 1;
                        if v == n - 1 {  
                            return dist[v];
                        }
                        queue.push_back(v);
                    }
                }
            }
            -1  
        };
        let mut result = Vec::with_capacity(queries.len());
        for query in queries {
            let (u, v) = (query[0] as usize, query[1] as usize);
            if !graph[u].contains(&v) {
                graph[u].insert(v);
            }
            result.push(bfs(&graph, n));
        }
        result
    }
}
```

# 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
